<?php
/**
 * Register the required plugins for this theme.
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin
 * @author     Gary Jones
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */

/*Include the TGM_Plugin_Activation class.*/
require_once get_template_directory() . '/tgm-plugin/class-tgm-plugin-activation.php';

/*TGM_Plugin_Activation class constructor.*/
function goto_register_required_plugins() {
	$plugins = array(
		array(
			'name'   => esc_html__( 'Revolution Slider', 'goto' ),
			'slug'   => 'revolution-slider',
			'source' => get_template_directory() . '/inc/plugins/rev.zip',
		),
		array(
			'name'     => esc_html__( 'Elementor', 'goto' ),
			'slug'     => 'elementor',
			'required' => true,
		),
		array(
            'name'     => esc_html__( 'Unyson', 'goto' ),
            'slug'     => 'unyson',
            'source'   => get_template_directory() . '/inc/plugins/unyson.zip',
            'required' => true,
        ),
		array(
			'name'     => esc_html__( 'Kirki', 'goto' ),
			'slug'     => 'kirki',
			'required' => true,
		),
		array(
			'name' => esc_html__( 'Contact Form 7', 'goto' ),
			'slug' => 'contact-form-7',
		),
		array(
			'name' => esc_html__( 'Advanced Contact form 7 DB', 'goto' ),
			'slug' => 'advanced-cf7-db',
		),
		array(
			'name' => esc_html__( 'WooCommerce', 'goto' ),
			'slug' => 'woocommerce',
		),
		array(
			'name'        => 'Envato Market',
			'slug'        => 'envato-market',
			'source'      => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
			'required'    => true,
			'recommended' => true,
		),
	);

	$config = array(
		'id'           => 'tgmpa',
		'menu'         => 'tgmpa-install-plugins',
		'capability'   => 'edit_theme_options',
		'is_automatic' => false,
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'goto_register_required_plugins' );
